/*
 * Decompiled with CFR 0.152.
 */
package blueduck.jellyfishing.item;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.registries.ForgeRegistries;

public class BubbleWandItem
extends Item {
    public Block block;

    public BubbleWandItem(Block pBlock, Item.Properties pProperties) {
        super(pProperties);
        this.block = pBlock;
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        InteractionResult interactionresult = this.place(new BlockPlaceContext(pContext));
        if (!interactionresult.m_19077_() && this.m_41472_()) {
            InteractionResult interactionresult1 = this.m_7203_(pContext.m_43725_(), pContext.m_43723_(), pContext.m_43724_()).m_19089_();
            return interactionresult1 == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : interactionresult1;
        }
        return interactionresult;
    }

    public InteractionResult place(BlockPlaceContext pContext) {
        if (!this.getBlock().m_245993_(pContext.m_43725_().m_246046_())) {
            return InteractionResult.FAIL;
        }
        if (!pContext.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockplacecontext = this.updatePlacementContext(pContext);
        if (blockplacecontext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = this.getPlacementState(blockplacecontext);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(blockplacecontext, blockstate)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = blockplacecontext.m_8083_();
        Level level = blockplacecontext.m_43725_();
        Player player = blockplacecontext.m_43723_();
        ItemStack itemstack = blockplacecontext.m_43722_();
        BlockState blockstate1 = level.m_8055_(blockpos);
        if (blockstate1.m_60713_(blockstate.m_60734_())) {
            blockstate1 = this.updateBlockStateFromTag(blockpos, level, itemstack, blockstate1);
            this.updateCustomBlockEntityTag(blockpos, level, player, itemstack, blockstate1);
            blockstate1.m_60734_().m_6402_(level, blockpos, blockstate1, (LivingEntity)player, itemstack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, blockpos, itemstack);
            }
        }
        SoundType soundtype = blockstate1.getSoundType((LevelReader)level, blockpos, (Entity)pContext.m_43723_());
        level.m_5594_(player, blockpos, this.getPlaceSound(blockstate1, level, blockpos, pContext.m_43723_()), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        level.m_220407_(GameEvent.f_157797_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockstate1));
        if (player == null || !player.m_150110_().f_35937_) {
            itemstack.m_41622_(1, (LivingEntity)player, p_43296_ -> p_43296_.m_21166_(EquipmentSlot.MAINHAND));
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @Deprecated
    protected SoundEvent getPlaceSound(BlockState pState) {
        return pState.m_60827_().m_56777_();
    }

    protected SoundEvent getPlaceSound(BlockState state, Level world, BlockPos pos, Player entity) {
        return state.getSoundType((LevelReader)world, pos, (Entity)entity).m_56777_();
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext pContext) {
        return pContext;
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pPos, Level pLevel, @Nullable Player pPlayer, ItemStack pStack, BlockState pState) {
        return BubbleWandItem.updateCustomBlockEntityTag(pLevel, pPlayer, pPos, pStack);
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext pContext) {
        BlockState blockstate = this.getBlock().m_5573_(pContext);
        return blockstate != null && this.canPlace(pContext, blockstate) ? blockstate : null;
    }

    private BlockState updateBlockStateFromTag(BlockPos pPos, Level pLevel, ItemStack pStack, BlockState pState) {
        BlockState blockstate = pState;
        CompoundTag compoundtag = pStack.m_41783_();
        if (compoundtag != null) {
            CompoundTag compoundtag1 = compoundtag.m_128469_("BlockStateTag");
            StateDefinition statedefinition = pState.m_60734_().m_49965_();
            for (String s : compoundtag1.m_128431_()) {
                Property property = statedefinition.m_61081_(s);
                if (property == null) continue;
                String s1 = compoundtag1.m_128423_(s).m_7916_();
                blockstate = BubbleWandItem.updateState(blockstate, property, s1);
            }
        }
        if (blockstate != pState) {
            pLevel.m_7731_(pPos, blockstate, 2);
        }
        return blockstate;
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState pState, Property<T> pProperty, String pValueIdentifier) {
        return pProperty.m_6215_(pValueIdentifier).map(p_40592_ -> (BlockState)pState.m_61124_(pProperty, p_40592_)).orElse(pState);
    }

    protected boolean canPlace(BlockPlaceContext pContext, BlockState pState) {
        Player player = pContext.m_43723_();
        CollisionContext collisioncontext = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        return (!this.mustSurvive() || pState.m_60710_((LevelReader)pContext.m_43725_(), pContext.m_8083_())) && pContext.m_43725_().m_45752_(pState, pContext.m_8083_(), collisioncontext);
    }

    protected boolean mustSurvive() {
        return true;
    }

    protected boolean placeBlock(BlockPlaceContext pContext, BlockState pState) {
        return pContext.m_43725_().m_7731_(pContext.m_8083_(), pState, 11);
    }

    public static boolean updateCustomBlockEntityTag(Level pLevel, @Nullable Player pPlayer, BlockPos pPos, ItemStack pStack) {
        BlockEntity blockentity;
        MinecraftServer minecraftserver = pLevel.m_7654_();
        if (minecraftserver == null) {
            return false;
        }
        CompoundTag compoundtag = BubbleWandItem.getBlockEntityData(pStack);
        if (compoundtag != null && (blockentity = pLevel.m_7702_(pPos)) != null) {
            if (!(pLevel.f_46443_ || !blockentity.m_6326_() || pPlayer != null && pPlayer.m_36337_())) {
                return false;
            }
            CompoundTag compoundtag1 = blockentity.m_187482_();
            CompoundTag compoundtag2 = compoundtag1.m_6426_();
            compoundtag1.m_128391_(compoundtag);
            if (!compoundtag1.equals((Object)compoundtag2)) {
                blockentity.m_142466_(compoundtag1);
                blockentity.m_6596_();
                return true;
            }
        }
        return false;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_7373_(pStack, pLevel, pTooltip, pFlag);
        this.getBlock().m_5871_(pStack, (BlockGetter)pLevel, pTooltip, pFlag);
    }

    public Block getBlock() {
        return this.getBlockRaw() == null ? null : (Block)ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)this.getBlockRaw()).get();
    }

    private Block getBlockRaw() {
        return this.block;
    }

    public void registerBlocks(Map<Block, Item> pBlockToItemMap, Item pItem) {
        pBlockToItemMap.put(this.getBlock(), pItem);
    }

    public void removeFromBlockToItemMap(Map<Block, Item> blockToItemMap, Item itemIn) {
        blockToItemMap.remove(this.getBlock());
    }

    public boolean m_142095_() {
        return !(this.block instanceof ShulkerBoxBlock);
    }

    public void m_142023_(ItemEntity pItemEntity) {
        ItemStack itemstack;
        CompoundTag compoundtag;
        if (this.block instanceof ShulkerBoxBlock && (compoundtag = BubbleWandItem.getBlockEntityData(itemstack = pItemEntity.m_32055_())) != null && compoundtag.m_128425_("Items", 9)) {
            ListTag listtag = compoundtag.m_128437_("Items", 10);
            ItemUtils.m_150952_((ItemEntity)pItemEntity, listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_));
        }
    }

    @Nullable
    public static CompoundTag getBlockEntityData(ItemStack pStack) {
        return pStack.m_41737_("BlockEntityTag");
    }

    public static void setBlockEntityData(ItemStack pStack, BlockEntityType<?> pBlockEntityType, CompoundTag pBlockEntityData) {
        if (pBlockEntityData.m_128456_()) {
            pStack.m_41749_("BlockEntityTag");
        } else {
            BlockEntity.m_187468_((CompoundTag)pBlockEntityData, pBlockEntityType);
            pStack.m_41700_("BlockEntityTag", (Tag)pBlockEntityData);
        }
    }

    public FeatureFlagSet m_245183_() {
        return this.getBlock().m_245183_();
    }
}

